IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_PROD_REM_PRE_VENC_IT') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT](
	[CD_EMP] [int] NOT NULL,
	[CD_REMESSA] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[NUMERO_LOTE] [varchar](20) NOT NULL,
	[DT_FABRIC] [datetime] NOT NULL,
	[DT_VALIDADE] [datetime] NOT NULL,
	[QTDE_PREVENCIDOS_ORIG] [int] NOT NULL,
 CONSTRAINT [PK_EST_PROD_REM_PRE_VENC_IT] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_REMESSA] ASC,
	[CD_FILIAL] ASC,
	[CD_PROD] ASC,
	[NUMERO_LOTE] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_NUMERO_LOTE]  DEFAULT ('') FOR [NUMERO_LOTE]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_DT_FABRIC]  DEFAULT ('') FOR [DT_FABRIC]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_DT_VALIDADE]  DEFAULT ('') FOR [DT_VALIDADE]

ALTER TABLE [dbo].[EST_PROD_REM_PRE_VENC_IT] ADD  CONSTRAINT [DF_EST_PROD_REM_PRE_VENC_IT_QTDE_PREVENCIDOS_ORIG]  DEFAULT ((0)) FOR [QTDE_PREVENCIDOS_ORIG]
end